#!/bin/sh

CRCsum="2995297776"
MD5="bd68b001390ed7d41c882ee2a03a47e3"
TMPROOT=${TMPDIR:=/tmp}

label="Systembase PCI/PCIe device drvier installer"
script="./Install"
scriptargs=""
targetdir="sysbas_mpdrv.v12"
filesizes="25837"

print_cmd_arg=""
if type printf > /dev/null; then
    print_cmd="printf"
elif test -x /usr/ucb/echo; then
    print_cmd="/usr/ucb/echo"
else
    print_cmd="echo"
fi

unset CDPATH

MS_Printf()
{
    $print_cmd $print_cmd_arg "$1"
}

MS_Progress()
{
    while read a; do
	MS_Printf " "
    done
}

MS_diskspace()
{
	(
	if test -d /usr/xpg4/bin; then
		PATH=/usr/xpg4/bin:$PATH
	fi
	df -kP "$1" | tail -1 | awk '{print $4}'
	)
}

MS_dd()
{
    blocks=`expr $3 / 1024`
    bytes=`expr $3 % 1024`
    dd if="$1" ibs=$2 skip=1 obs=1024 conv=sync 2> /dev/null | \
    { test $blocks -gt 0 && dd ibs=1024 obs=1024 count=$blocks ; \
      test $bytes  -gt 0 && dd ibs=1 obs=1024 count=$bytes ; } 2> /dev/null
}

MS_Help()
{
    cat << EOH >&2
* Release note *

        Before installation,
        make sure system with c compiler and kerenl development package.

        Ver 1.00
                Test RedHat 9.0     ( kernel 2.4.20 )
                Test Fedora core  1 ( kernel 2.4.22 )
                Test Fedora core  4 ( kernel 2.6.11 )
                Test Fedora core  5 ( kernel 2.6.15 )
                Test Fedora core  6 ( kernel 2.6.18 )
                Test Fedora core  7 ( kernel 2.6.21 )
                Test Fedora core  8 ( kernel 2.6.23 )
                Test Fedora core  9 ( kernel 2.6.25 )
                Test Fedora core 10 ( kernel 2.6.27 )
                Test Fedora core 11 ( kernel 2.6.29 )
                Test Fedora core 12 ( kernel 2.6.31 )
                Test Redhat Enterprise Linux 5 ( kernel 2.6.18-8.el5 )
	Ver 1.1
                Test Cent OS 5.4 ( kernel 2.6.18-164.el5 )
	Ver 1.2
                Test Ubuntu 9.10 ( kernel 2.6.31-14 )
                Test OpenSuse 11.2 ( kernel 2.6.31-5 )
EOH
}

MS_Check()
{
    OLD_PATH="$PATH"
    PATH=${GUESS_MD5_PATH:-"$OLD_PATH:/bin:/usr/bin:/sbin:/usr/local/ssl/bin:/usr/local/bin:/opt/openssl/bin"}
	MD5_ARG=""
    MD5_PATH=`exec <&- 2>&-; which md5sum || type md5sum`
    test -x "$MD5_PATH" || MD5_PATH=`exec <&- 2>&-; which md5 || type md5`
	test -x "$MD5_PATH" || MD5_PATH=`exec <&- 2>&-; which digest || type digest`
    PATH="$OLD_PATH"

    offset=`head -n 298 "$1" | wc -c | tr -d " "`
    verb=$2
    i=1
    for s in $filesizes
    do
		crc=`echo $CRCsum | cut -d" " -f$i`
		if test -x "$MD5_PATH"; then
			if test `basename $MD5_PATH` = digest; then
				MD5_ARG="-a md5"
			fi
			md5=`echo $MD5 | cut -d" " -f$i`
			if test $md5 = "00000000000000000000000000000000"; then
				test x$verb = xy && echo " $1 does not contain an embedded MD5 checksum." >&2
			else
				md5sum=`MS_dd "$1" $offset $s | eval "$MD5_PATH $MD5_ARG" | cut -b-32`;
				if test "$md5sum" != "$md5"; then
					echo "Error in MD5 checksums: $md5sum is different from $md5" >&2
					exit 2
				else
					test x$verb = xy && MS_Printf " MD5 checksums are OK." >&2
				fi
				crc="0000000000"; verb=n
			fi
		fi
		if test $crc = "0000000000"; then
			test x$verb = xy && echo " $1 does not contain a CRC checksum." >&2
		else
			sum1=`MS_dd "$1" $offset $s | CMD_ENV=xpg4 cksum | awk '{print $1}'`
			if test "$sum1" = "$crc"; then
				test x$verb = xy && MS_Printf " CRC checksums are OK." >&2
			else
				echo "Error in checksums: $sum1 is different from $crc"
				exit 2;
			fi
		fi
		i=`expr $i + 1`
		offset=`expr $offset + $s`
    done
}

UnTAR()
{
    tar $1vf - 2>&1 || { echo Install failed. > /dev/tty; kill -15 $$; }
}

finish=true
xterm_loop=
nox11=n
copy=none
ownership=y
verbose=n

initargs="$@"

while true
do
    case "$1" in
    -h | --help)
	MS_Help
	exit 0
	;;
    --lsm)
cat << EOLSM
No LSM.
EOLSM
	exit 0
	;;
	--tar)
	offset=`head -n 298 "$0" | wc -c | tr -d " "`
	arg1="$2"
	shift 2
	for s in $filesizes
	do
	    MS_dd "$0" $offset $s | eval "bzip2 -d" | tar "$arg1" - $*
	    offset=`expr $offset + $s`
	done
	exit 0
	;;
    -*)
	echo Unrecognized flag : "$1" >&2
	MS_Help
	exit 1
	;;
    *)
	break ;;
    esac
done

case "$copy" in
copy)
    tmpdir=$TMPROOT/makeself.$RANDOM.`date +"%y%m%d%H%M%S"`.$$
    mkdir "$tmpdir" || {
	echo "Could not create temporary directory $tmpdir" >&2
	exit 1
    }
    SCRIPT_COPY="$tmpdir/makeself"
    echo "Copying to a temporary location..." >&2
    cp "$0" "$SCRIPT_COPY"
    chmod +x "$SCRIPT_COPY"
    cd "$TMPROOT"
    exec "$SCRIPT_COPY" --phase2 -- $initargs
    ;;
phase2)
    finish="$finish ; rm -rf `dirname $0`"
    ;;
esac

if test "$nox11" = "n"; then
    if tty -s; then                 # Do we have a terminal?
	:
    else
        if test x"$DISPLAY" != x -a x"$xterm_loop" = x; then  # No, but do we have X?
            if xset q > /dev/null 2>&1; then # Check for valid DISPLAY variable
                GUESS_XTERMS="xterm rxvt dtterm eterm Eterm kvt konsole aterm"
                for a in $GUESS_XTERMS; do
                    if type $a >/dev/null 2>&1; then
                        XTERM=$a
                        break
                    fi
                done
                chmod a+x $0 || echo Please add execution rights on $0
                if test `echo "$0" | cut -c1` = "/"; then # Spawn a terminal!
                    exec $XTERM -title "$label" -e "$0" --xwin "$initargs"
                else
                    exec $XTERM -title "$label" -e "./$0" --xwin "$initargs"
                fi
            fi
        fi
    fi
fi

if test "$targetdir" = "."; then
    tmpdir="."
else
    tmpdir="$TMPROOT/selfgz$$$RANDOM"
    dashp=""
    mkdir $dashp $tmpdir || {
	echo 'Cannot create target directory' $tmpdir >&2
	echo 'You should try option --target OtherDirectory' >&2
	eval $finish
	exit 1
    }
fi

location="`pwd`"
if test x$SETUP_NOCHECK != x1; then
    MS_Check "$0"
fi
offset=`head -n 298 "$0" | wc -c | tr -d " "`

if test x"$verbose" = xy; then
	MS_Printf "About to extract 160 KB in $tmpdir ... Proceed ? [Y/n] "
	read yn
	if test x"$yn" = xn; then
		eval $finish; exit 1
	fi
fi

res=3
trap 'echo Check System. >&2; cd $TMPROOT; /bin/rm -rf $tmpdir; eval $finish; exit 15' 1 2 3 15

leftspace=`MS_diskspace $tmpdir`
if test $leftspace -lt 160; then
    echo
    echo "Not enough space left in "`dirname $tmpdir`" ($leftspace KB) to decompress $0 (160 KB)" >&2
    echo "Consider setting TMPDIR to a directory with more free space."
    eval $finish; exit 1
fi

for s in $filesizes
do
    if MS_dd "$0" $offset $s | eval "bzip2 -d" | ( cd "$tmpdir"; UnTAR x ) | MS_Progress; then
		if test x"$ownership" = xy; then
			(PATH=/usr/xpg4/bin:$PATH; cd "$tmpdir"; chown -R `id -u` .;  chgrp -R `id -g` .)
		fi
    else
		echo
		echo "Unable to decompress $0" >&2
		eval $finish; exit 1
    fi
    offset=`expr $offset + $s`
done
echo
cp -rf $tmpdir/sysbas_multiport/ ./

cd "$tmpdir"
res=0
if test x"$script" != x; then
    if test x"$verbose" = xy; then
		MS_Printf "OK to execute: $script $scriptargs $* ? [Y/n] "
		read yn
		if test x"$yn" = x -o x"$yn" = xy -o x"$yn" = xY; then
			eval $script $scriptargs $*; res=$?;
		fi
    else
		eval $script $scriptargs $*; res=$?
    fi
    if test $res -ne 0; then
		test x"$verbose" = xy && echo "The program '$script' returned an error code ($res)" >&2
    fi
fi
    cd $TMPROOT
    /bin/rm -rf $tmpdir

eval $finish; exit $res
BZh91AY&SYx >pa 
H`r:ͼ  7( S}oë8]^޷w<[aq{}ٮw3麶{}uj6S]{|yPm qۇ=%ޯH77)oztSUNgﻸg.}]dzmң}n9{[wwW{ȯu\N'7sۭY;{-덱jλجr\5^ɽup7W]V.m4eKtnveuy\[T-*Lw\ljkThjӝNw6+.hV+v=[D F44 M&jT5OOOMiA~F SA	Td2(ޔ{T=#M

    $D	i4ɩFdC@h  	4M0#%<TߩL)M=#Gh=4M4Ѡ     $&&&	0FJeMMiiyA
 @4 @`5*{OSFQ⇨h      tx)oP>]Oq,Vai\2/<" h8`yMkU|W-q6یXK-pJ.3i	 ~s7oxQ%cv5dqІ-SdTl|yYXH{%-"⾧p}.0E,@a_j	HģDa@9'p~E!!#B`%
"ГÏ !ZT Hu'5 $ۊE k?wOJ	A5`_cM)'dBO?X]`TwvwUP /w|}7jo=4"MU:i^C4ahq(ߝBQQB"?AV0"'DP ,RI
TXVTUd8*dR EY 1q@7
"Q~JL5 +XgKW*Vb,E`F0P`HA cAE
,fFM*%hF(¿$Q Ȃ@Fb-%1=005cc!T'dŨ2Dd;艪%J^@ I_ⶩV6<{dW1t꓅C$aٺ孶98:
c-Kư&5fVtUͺyb1/baeL};>hRX^lc=;wX4.IA~)$=l>FH 0bPْ́3h@EXET>JfCV""ȈD,DbFQ0TR"((`XȢ*"0DNp)d1y[V# 47QX(*cA`(X!PIJ5Tc((,XXcEDE4dHA$X,DAbՀ0h((UUDT`dU@Ubb*DD,F" 0HXH*AP<A6V)(,Q	"("D H0 =sM)~9Z+E!(gS5&"ք1;uFj"b"1 c1NNIX"!ݷhKo1siL3v;.AǞ^)4MR}pXG!9Kì gD9#iN[/ï7'ёQl)mHܤn̚BR-`31q*WT)RT/Lcg0Y8iH죎W,,18l0,iZaTM4Yn1"
gU,oK(I[mxs\k2mW-CC]T]Y5E,ayX}%l y0k&i]ыiN΃$C'r2zDbQַwx٭6!
$P:јt
,+ɩʬtwT/,E9h#9ZQb;=[XabVjIAgN\31X

TL4U38HUT;p&sgg]AIb{wQ$MvA ,	9ӧ'-q*L`.bTTӲg.1+s&REޕ*WXf&%
EBah(;xPqR2edvE%ETAE`MhLq0bl1YDl.ʒ[fqehRfY3,^R)Ԑ2EVEmZ$b,X,Yen&Rll2%@\˭<+=&` Al*zCs<Y'L mw:>'Cs<%݄%#ӟWg; z"'/MoOGGN5*rC>~Mߕ<^aT˰ҿ2CT4d0(Pq/׬*#z]O@UB`2W3u8Ikf,%tAǜ̫Mj=-[>]=erbo2m
!qi2m<T4"E\vÎi1C9 LvЩ5Ȥa=Β8u W߸߶m{^9?䙓)FHX#"H(
AFPi~'}o<~g>ٷk>RYKvc(/c?J+7C3^N
#\Z@,Ϗj46/nkQݢHCIӥLmD~0()TNV'|]p}qmna'$6ZC+@픙br`
>bÆ&?֐THJ!2:T%e"'B w[bPF^"LUSªuRK_UUZ媪-]ӑUr=xUUTUUt]*UUUQUUVUUqJEw,!6BE XLF)&!Haa2(zIe/xG}] 7?;{Sϼ}/??GϋhJ0X?TP,>ɻ:~Óy>捂f|?((~**|7t~
G>ɍE?G(:*u5/DlQukŬ=^&\y(}Y! 9?w)? b\Q"CNvWx:=Cmh;BNt&L gZ ٨~vg(CAdo	+M@yh0~N5di			#n]ɰJ/7(b
Z6jMcL"	շ<֏Vw&ZgH%u/챳!UY/A|AǊ!ԡ|-,0R˘FkVK|UUDrf 6陭Ԋ|#3@Ȩe'	\Fk 翅\˔q*ցM_gȆ4O}Ka3_&xVLr#3DdG	(<K|՜,=oD ]/GbbX
b+3=$PrAF+TC/m֝d><pEEPm")ᱠw˿j%Zt:=󚛪RtpUBiRypROh3<,H&بq	 8()4 4XCSE$Q8$8&NF"|c _>r>wP< PwrxO?&0qexbZ>2pFM!7PP><"%əkZPüꧺꭃ4r3n31/@~ffnzVtlo||ۨ*gKz~Ѱ$LxsyYRʙeږxA
B,=">LpռZ9驙4hy("DHF`8B4P^38CڙՃ݃ǉ4ѩgJ* I#ͰG9t>5S3D=~wh@1>ߒOyD1Jm}r_%P`{[jCYZE:,b:#	(Q
E-)Jd4}&sHRyC97"LL+A͕N吡7w%4'g PVFb6+#=.=sѮ2$-`5foNB1ic(O#ix-
w3՜߆/UUa4xfƊ	X	N{=5b=NH>oy<'@fA8@"bFqD(D8Ր YHF
`ӽ%d}$"wGiXDIx1}6cVjZbHdŇHNӸt&M@^SX5(:Lصci3êNQ6j,H4 $Y2e[%Mѥlj	Azu**a/v6Ynfv8q_GӀYP[C5lA*Ԓ o͸[ֵmjer~s!"%t
G D>|ƲmixGcF`Fl&:C{tuu}e,8MJn϶eP@fY->v갶}&iR|v>k/wX>(@[jo+}q	-z"qnݢ	ԲG#SI&r	y/FtBxƔBQ##HѤ܊$}xwLCY":u|{[6f˘莤]nDAs=Cǖ%0dr
9p=|~1ڧR(yQE;m!˗.W	khd
m|}xnж#;M){[NBębdE\L7[@08%I"" `#iC,I+!TcBy`9~Ş\䃚<߼vPͤ_%&
!$6Fpq RC,Iْ>\6;Jopwq=i;)ɫ00E#  F9G1ۂ
,u&UI"%EAUWjU´J ÆgZ&><'9ԇ>@+h	YH4aXOϾ9`Dtr79SCVPˀHF\=r޿͞D n4&%7*Te>1D\hCIŉ7
QMS鍾	WO7.uvغ	SR:R O2rKh`X	UN>@a ɊoK.N^nӇ u#8wHr=
o=宏#0p[l9.%ZDU$eO#{UбڍN
:3 ŰN
[YtT	
R,DJD0&d*t<wIܸ1˂W+	X*"\.r]6/ˈZ-@ey"Ryn]IIj1l> ;m0ׯ3GS:-(a_nZ`)JQ~z 
.DJ"" +!FJ(0t("#~VOohr0<Q"Lssڙ0QE4PYpOߊ<sLгyu7
>8A_y3F*PW[Q	&RNmsIa%BHZ =did~;4|b|N@,4@~`@dkR@9)Ak`Daz7Θ7F\tЎѿ%Bn?'i!=,TrHnVxDf2eE	U%34PuuLuހoize
H]2^
|'%xG"Ni/"G3][UAb!sѧB^\)5Pu[XZ
I>!+.47F[pm~dd@"^a@29ݝ 'P(H)EQ\a̼uzog (!RVEY9Me,Cp]hvX ?
#ջA	= W̋X`3`7.OQv8MU"g}H>U{xߪ@$XW~}揎@$uk^.w*c>x2&ƀ]E<p|p)ЃO?çyb;
&1v -\/ QD⿻IY:^X9	zť(;~WpMUUUVQZP13I0?L?$82ÿ%
idCA$CI _o:MnEMcRB	[3&jv;<U3쵗>j"H*'~y")#H(AXĂ!>׏9{II^9,4!(p	>_O1_sryNA;CixiMs J$_52Z5y{GleuJ{podzY.azY-q0!)r=I+G@⧔A,}9/jP@x>{O~uW׭;uyPn:	S"*ILJ_>}Pc6F9I=C#2x&8i(|bhcPfGds5;9w8L#	z\i&(VH_/i$C~jsn&S+Ŏ	9FmzM#H H$ .U ^g4ߪyaĔF|Aa(6<9
	
c쾨."UPJWygVǆyYE\?crp<І%՛2=P8,qB@r:<p
GnAlć32_Wz~U|K	0Y	QG=͹h'عd94؍]i42Q$,EPu&
S{i{칼zGf1G7Dq @rπ+4Ok쁀qb!H(gq@tN6u>;ph@+s}UùWM_~+uXGe`6Hhr]0p'ML)ufSW3U
#$7gFvNt3fhj[N񴯽e#8*.C[n ISŹ3H;Hxp]'fN$9\BϞxW t#]+ʨNR!{h)i:r)2bT^S3F1ZW<hʨ4O;;_{l?oqt#PUx$>7Q*ó/OћW-oew+
DFgo}:Q$߇dןS>
zt/aՖ$n# =e-q4
pfA*ٞdѽ4ԮXK(ϵI7Z")GXa;<m͒4c=Uc};ϱ Z=*[ aM^bZ
S*$GHɳ:bNo0>j*E5Ӻ\/p).e<1m-e,QTf׆Q: k?
6&bfcNzoWw7ٲCa[D9P<--\=DRgb׃ * _|rta&գ7FH\az7x3c$pF
x\4=jB'6q
6@ؽ?UZ'z`	5Xgm4;Hb%@	Pk.⯎J珅IH/ٷ\:8ɝ|E,E[u4JPVބ-l]`q)gY_x5)/=aϻDZ6Ykt/W֡AϐPPﮍD,uP-S4.ж#%q6Cj迎!tB^-{v837,VpQAޡ^hY}/K &TgKOvxbњx?u=^DȁT&d/?.-%"	$ARE X# F@D?B`"Nm"DabVHV	6=ABDaGlFѢ/`#i8*9݈Q,:qSX\fXEsY r=9R]	ٖJKx%MܙG@
(S++
wY["㮂H__VJ}d8-wŰ9@7 0@ܻ ǣ:\s_%~z uD'>c0<)Jv@6HB@ څX\lv-GdNOOfG«GFw9
U;(E77 бCs(aABJ q>L:弔|wf[/kKwM>ɶa\YKktteJHx u6<:e	MGnVqu颓͒R̆:0RaϬ#6	
T TQW	pGVBē}o+뮋V=BnX^<Fᬹbk[Sӯ7ڶBX7j!d- *\n kx05"x_|L`vJvc3]h%$,!0sޖVV\]<6P"ŒTT`l`p,\*055% YJbaa7XM.cL
I4Xj$5QC	٣a
BPt1$d\Y:H[
5PL l`z10N9FP8i-?O<Ѧ	4.'Xd(]sǪۉ{UYUʓHL]0.c/mLΞUy=mt2zf^ngk<ŷ<6I<mqj"b}(va.e\U"t43S%y&w74}8;<5z;I39OACXƐKq:v,gwmܶBU~AZ<eDdADX X(ABl#,d
365'wa'?Hlv2=27֒B Q
I oWIwvV0 wiW%T&RyYes**"2xPNQ,rRZD>M~/u"d龋vUZӍn͢ba̶VWhV*a.gW$*ޯ!ODBǟtrko'Gݎŋj	 =XX gDcoQ	y4[dDsz
UPL")fG9ߟ/`@0 `rAUgs9Xu	{Yۚl/R[~pmf#W3gLւt9k&iȓ/B
Z9$2i!Dbm0-C	T:b	.ܟ V9aR$"aj110sJIq(>	UUUUTV,Ԧ	 KGG$	 Xտ%moۘ1xzcaDR\]c*6.HJ_Uo9A4?'$хyIUGd(Z"^ 3z	L(䢏
UT b_#ˈONiL^qx~w!0Lk[8Ŋ
C $<3AtmzuXFc';;: &SsĸA%)33n07$\
O&o#
wӥD/dQ3KŸ=И3eV8_ /|aq=/#q9M%Tlruyf,1OQBk"-5R0͡ <Pʈ1L @(8=MtdK|<2uIly5!Jt<k$NCTc@H
ӡ
e(*K9JngU	xd@0@ҍF;:e-#)@j-@<L4[x0nQ1FM1|i^,skly'	]_N3ie{eyFs{aJu
*ʝv[Y9
5hs;+u	$ )P_wky^[wZW
/^Ki	="zt+tK54ܼюj5/m;>6x	qu.t
ڮB'6%]w^Fw8J2 !P'8,R s? \рD`ދ0x6oqPJ2Q.Hfs9Wv@_8MZ9Dp,Aq\w		y
x=s]>/{Awq(/=>?*4Z=KP˜quήY>O/B+3yYy KLkV0d=Ieu(T">c6pUO>ӧIl߾>U^GWXKMc5V^{xmXHo{]j(?Nd6iCYȕ+T'~#aQ2 Um-eW^\8{9?_ef9ף~sg1q-M'R差깏վ@[&Vl|tZF$K.\r5ֻ7z,ucǕ+ZXIP;8Q-:l?OS_<-&Z_JO|774IU+s۔N{m#)W&3 qAq@!ZR_*
8uf`v/ۼuܢ+܋W/sRC?bEمr]ַ2L+e],[a41T(wÆRc5{71t/#)dPs5]3 RX~#!Nz)B/<qcjH4ZfhWXeVVMƅfgd
=֡FUAa
\tY
.2#VU*T:5XMVWwMtI;1[޵iZ/]"@3FuClq9ԃX2Z"ro@Ly3I;ӫ!b)t?Н	21I`@5Q^:"R(($GvLb\]/+jmL6*
yra3#IN0ٞu_uJ7Pg87%ed=9i[t=J%Jx~퉇OşGӝ Rh-ygI	PxGkgf^͚;oՇ߰s?bwNiO،R@ȃ'Te&(!
=P/~UVԱ?4X.dQ1yhwL9.;d@sy%{I1rpJg^,0'6я́ǋa:ob6L"U)ja@5F*<5ﶂ0@ф4ym<,o]?x?W6Ytϧwu'zy!b[On]1f+m@˪CI?LlK;ȩ#C9ǳ}? }'_ߜyfj(w*>qؼ\M2̑sx{Os_p*AO	@}\N`Qz+YE3|!.Ȓ#H)E-~Ҋom{9 ^tPkϑN/
*C|zם[DL4(#Eԁzˌެ׎^pny3]!:yG`̀IV"ĈγWf.~>(@&2$E$0CH_/`:3̓w9O??F QZYB,]y7\܁QqO@P?f+щȎTBIxF8\|6џU!uAxRj܁97<KPXdDmmH[F9h[
@4v' i4mI$8
*#KuSZ*;8<s͍MeV|%yZ139]ʺ )Sg\v.r{ZΉ	B 9Yx
I }7a
Nɑr3zJQBӥ1^#/f^kP+` xJn :]v㸃`m'|/|BFMLrB֔
@w5T",#&ajh]Ġ2ɦ&CHisCtfdWs[hA慜i ܶr=]*ln
̦9yF^48.LK+B<!A@ mǡ
#(N8	5I!<9dg*h	E5Ni]ĢHU)E0r;O!,*.f,;)t&JV/e
`VK_U"XȍB;qA
h ڂb?IM6u|ԍ@xdl=͍w6]Vpя.O5YҪؾ̤ߌjBA4stD;wsW΋wCofӇF[Y*zin V1ګrMV%g<U5kavj
BBByq%a9 =nl
 @70@☙{,$r"L
ĊXZ
z4rI$t8:MG5HvCN	"uq9`: QrXAp!YNts9yAn/6PBI#F*N0B+{IΤA!t+4[m_pT˂T
91St뀹z7n3ucrv+4YDHS6ࢃsez҂rpu
`c39{a`i Co|XgHR&"'Qb8btWYS/'!+o.izus$E`d#2jZAb])eР[wIʒ4"
O1BD`oP79yiO\¡`	6AV`=a7԰-
7s(u i'
cH!ӜLxvlL
T=de~ lWP̄FF$t qhIs/ 0S`dZ1/;riD]Ĵs"
˩D<J\
K~M&)H88B ƴҕM)왨=ڭkϧ.G.]B,۸oy<S1],TS3 w8%2h,%nr	a*Xp@Ҭݧ-CIM7ĳP7Z	b o;["s?V|ĵDLcjVhᑴηC1LIUJ'4^T5CDj?W܃qxMSXi6bfhʠ#cm{p<]5CyJ[	(lɻ,&CCg쌆ƼZhdG(S7Tw7
\\m8
Cy0rK`:]
Tu$HL&w
2N2\A6 a(*3
6LOkXLԦ,!pL # E#$zB<YcPc2"1X40Md7(A&H0ޠi6Sl`..daS5p16Myw!ܒJ@Tg Sk5to^0oA.}.bǴV͞΁3e6ONjd@`s0!}zXV鱭fN7/1>Q: Њ,EPI
+̇3[wHV#ܻPn&["EЁ X:7$y}:T{SI3"ád-D!T3}:tk:jMgBV/W)oۀs
m<sd+v?#qAE#n]qOeD0ݝ QtIcL䇖lol?}r ôoX^'	fa mGc<N:L
Ŋ,yarD<PNT8WF=ko(!
O1q8ApETXđdP+
0+Ͳϣ#VHCTU;AGu݊ FnV6Q%`]؉wtA׫]^DUZz HH$LTwgiyP02dCMh9N )CDC9"؀ 6>'2n}yȧ Q-?6$<cN#!ŀa/(Sk<2Hila
/eU3ذv
:az0ݰ vhR*mF	 d)gv!]!k@sz!w!Px>`{d$dΟQV-WיkMh`Gl)U(`LP@83sG'pP~*^4}_+=lydpB<*2(9Β(ߧZ<!s~*
	OG
:0[|>g4$=U6ug	'@ }9.t!QlR0tێQXtCo"DX
fd8Se5 X	!Ĉ3Lqۃiu`pUML#F `MIˈxy.$eHX4gn7;./DYEV*Ǒq0A^1P,cNf92QސpH"(5jI2uwYQUQSm!͎D9ɝېDJ9BFhI 6ˌp:9 ;aHlI~M%Nmң<Gimz(pdHl@	.1m6-SLg8pSSH(AaFKN&fx_~Gur=PTJJ>';ݏ\>?_p v]Hq?	
YzV!hdtAu7fNu0:Yauuh])[CHhQ$8:0M\'~,$:~N9o0:8
ì(1yaGADGlH3TMoZfAP{	)gP0D'a=r:H
 {ɠt޸h(YmlaDN,'C~ĖNr<<#Qvd;j.HI'Kͮx0= kٻ5 DR\%@Ycavl	tgC+w;y;]͐aSѰCp6PCEܶ`"CIAd&N@WRG8BIYhخR	Ẫg>N'"():s5h-!qF1 B%bBkښV6`l(#'o&e˓X6R
[#(AN uOU4le
]n.l⪣TE1#lz^hEsE\VK`DY	
PCG{`4 )a"p	z6wH:HśHzm<@d2<Ί _D;@H@{Nd%ɀK6aVЁd442	壼6.o?0Q"dbxIIjRLDĴb,Ctc Q`7AG;ȐKS$>PX"h Eg,#b2 E"/TH@h]\`)/i0@{FD `QTZF݄m
5rcW"!+'zOZ*Σl
'GzX|iS	ҌQeElx%x;]cr$FԥRH0;:*d1!°Z3rݙ$@*`{j-}Lتo n3:NDɢ`s\`Ă|aq""#J|(9S5κάsǃ dUجffhS/J6:rB1˜zbv^eU`BIK&$[ٚT<|)$SԒ^/Q[`	"4¤4
&R@lwtvHP}S	$6Fr8*,`?u %chc4RGTDeDA>.2dȇm<!?;< (1z>9tCf^( p5p 1Q<ŏkP<'mh1"MIW!Y5.H.}Z^Gg#FxɃ(Wy"B	s\o&{f{4B !2 Ǣz%~ܾVJD(
k}G<""2*(٭@1xH-QyaO v;TIÑHRnͮ?QJ&Oda@s\bI3"5R&&gK%DE,̥QPb%".=FQ'=8y^s<0^Dcw(q'2$;J	Kbu[<k'5iE
5BE!ɂpc\iJL*]~;P?RTBsL
Cf!91/P:bAWxk`f]$qE\o "GZn,Lp4V LCm{0`mlgUW:.ʾsQ ,(iCrCdP@̀Zut<	!Hdo`8vgϗ.0`P!qAu5V4i7vJPw&2i Kz'C`Xa:Ѵ qI
5iq^㱋N#ZD1XWdn:
^V5$\&,9c6I6jfL⪪KH)ntQb"(TLo0@2"(S8s}z;kp6s8G4!T:Sv3cC=CP*Qb"6D;$&1F-7d8>
z6z͍!q8D2HȌ|($!;4 \sg0ek#{yK[;A3w&ɼn3Tm΂켫'mr) |iee3kX@ cjjsu[`oN|;];jqXXbɊlp6rt
9HAaREAS	4>ǂz#!?EC
$r7k(f􂛂(:I[u2տ]7Imy	c4u*3*pB a 	+/
nRHH*FQP`Se;/I>g^șǞ80b@y1'ɬS
r;䏌HXX dיI/&bDw($6?2iN&_;.
YD
CX5!tweYaVխ`;ϓN %g2aLa$fّV4mSey!.
 , ߻Ԇ\YJqXHHw]
yI"c,'=(a ArzFQs7E
80(,Ќ`$TKAQETA(Y?t]Qyy
	(&a 0yynR2S<4<||J=XTYC@Ct`Pr0*pkdqAd2.(D$AZaiF4|ZEKfBBI=xPУbiS׸N[(o"J9<ԴJV>ntp6.Pϥw{M{QRB@T`G[#q$dEl9HQ׉V`e40V¡\άQ H$ !g|ɏX7B1U\'2SOuoXfn>M!wE'e:diDEO0FRF11aƓ%HF_͠&DHE`$jab kjC	&6G "i%Qrc~VNԠj
DP!b:x&=jmbXD,0u;ĠxmQK=YT4V">{RqH.	) 6I6<g΍PCph3p8>a会A88>`tߖfFnH`
0⪥p@vB
SΧ: ׼xƞZUkKim-ZUMV2ކ+W'rS:a@ D^M$Q+~BRdTyY`%Dq $D1$'a_qb?o0;ɒeC/0¤\QrkMG}gG,Hw8
?tA=$&`$_؅H2"xD,@Ad
c#-h)dgC{dg`
m
)H]jjEM+`b&ƶ)=~ޡM%>$
dw{6yAy(dA(b 2 2aJ2kp	bFR`XC b
!&8e66{қR N|
iwޜPެ`|wDE@A@VDvۧ0om95
pЉ:8{o(h3gVЭVfDD:.u#Vw>{MvIN1X:`翕-	Ra2BHQR,`P>_}"?`35T Fj8_7֯&oPPx0viyiQc&A%%a	a VhJ=}V"n@A
 "}Gڥ {msoby Y,0l21ҕ@2)٠`L(Y(Jf+"-Rf ZX@a"\Źҵ-&$1@BdBNi*	qk
tՏ1D tCˇ@@`/J b$hP6);Fbmɻ=$Q~/f2_:9vy͗1=TvV*42mL**"[d$֠u+xp7uaچ"hV/UH/ȝ.Q6HFX0UwЈDz9B -͠ܯuuNJl"!_ݞ==?MhEfǖ%,iдFKӷ:;=5' GmmTqP%s.bsv$hh8zrfnLhUL~$!%<,E {$߁{Y*gT28 Na=΅ %<C}>o1ll|.o%<evٶJ5H!12HS1eDL( h"3HEHO))ZQN#
<2$ۖ6zlFET$ cʯDLi(1uIe1k2~`ag&s#UHA-dR>80hM_d{dBAeB~]MM
Ur	"W!*ĞГ%(BwKѸfnjiQ<lۋ"U7Qu4)F3@4I{WFfB2́}b >m"D70I
.Su\S04AEI	Pif 
(50H.+u$BulI)(5j0 BH,D!UщїɊ ٸ6TgL=a!xI11X(=h@"LeH:زSYi +	P	D$(NRAQ$Ć&X i #0)&,B*ޮOxjAC?Ld;ԑ$HGi տ
5֎@s}Md o&@H:m{H=<7 w4 KITQ	@<|!tQ\wR^ϸg9u5{V=GçTm\Ң(E.!I3hHO԰(^{Q(3A<U%`Ix
B(kx2a縱tvR(&RG5l
v{R	;,DnۆV%C3~`7`[ohe`=DF >moXLHuQ$AX_nev*Ju{#"zI	<v:B8"=uJ-'HWûvupYg(8$hjŏZѼCA EbňC}1:@ی
,[
 2:j8"&(dB(-HvIpЎsfew0P`73*eD['26h
a`,9*KαUd8/:tvQD e{*3\2EC
k4"BqJL8B0T+0)RH),2#	o:m`d$S4\&#v97eqxE5EE[	"d!x|h v.4Id) ,繢邈uR+:&_;҃C3>/'79<! @<,6~k} s,NQ=<Az`EJf
BP{$Kj[Sxf-Y!Q$-CCc EH89
tう%'>a^8.pѮ́ X;J,k`[XbŅKl,L6EQe!e&KZg#	WNi#\ cwBߍWKmBh61&96l|*y=2 5նAF	2`{3X`6Ks+Eq$:P
1vPϳP
	R!
DaRU|>:0a;W3AӅ|sFqAbЅ%;ȄBA6	kR)̙<w,1뚇Y;ɛi	$zx1p(KB2OT WBAh gdW	7!)C@NZezy	TxA=--F@>
1NG0ApA܈?%ܒHf L`b4 xi;Km@k*rwt~q~Ƅs@b" u|и~9LXDhLs2,H$"(2# WF"	k)L   0	xE{[̟@z|6f7BZ"{3L8VdjcA&խ. T4u&㡂K;rA8Xɬgf :QٻhrmjzHI	$r.!_O
sl:Զh
4wJamok;00	Tq'
f.1Uai,@eWGo1)dĪ
8A/i2K7L= `:ǞsǂB0YC[Oc.C]8g*MOk k0KI`UI3wQFWeDׯ΀ȩ
;@C`D@S,Aa$γ7N>y'U	#T0CLtJ̤w1|@$Lf<9ڤ*~GF.L^hNC|	|BŊFyuѽC$,9^isÀ(=@GY$k)y,.#erhI;{nx=^3&-N0t~PH uM&RjmhB,R[E˺[}kdKto!,X|dń!6Efc,Od٪iժ%8VH➓'.d2湙R34O;,39rZ-ZBA* ʊT$r=r,!pZ&&k@{X{htm.[@|B8aG/S lbv~LͰ` :6%xPDl$XPb@)EK
6lbJ!m=̞; qOT$pvVcg,޴ܵ܆֩>s:<N4Ў\6qcZ≮$$Flͦmmǔ	iىay"m5)aC5q8aCfꓢJq@eHͬ1
 C8A{--YUx8d#TmaȁP4?=k$h P#ƃ(jnanѲfTH 2BŅ2K*KR$.fWˀ81(Th].3l t(%
T#4<f@45q!F6M-IT\d]]1Ҍd̝5dG$ɢʣ+\H!MUqƌDA`FPA@e6`l12JDhB Ĉ %[Ichcxo͠~8* 610liLjHg.fIm{X6M|C5"nBLC5D"99vZ\ʍCgS@[[
\ҊbS2݆@QJ
`eBځqQ`BЦ\l6*A ,"l`H`K
(f DG%8!/E:d Ê
	 DHEFBx,K, %>OwCʔ
{-Oi
T6w58;K:YqqR)Z!hI:W& G]{@mSIGa6ef*# Jlbx,Ptj+Z3:hTCl8q ~e-#	#k!NQ B ǣbkMi%$J|`/5yv'`
j]'Va bi[=/i8iq*v=_FKaˇg3s9%U3AmCrAU#0ad42rg'F^MXeR  뱯!+]UMF50
ók_Zg2Dt\>'3~<)9xFư~'|XV ;kCx AH7<7 :_0ARZjM7yDʮ}hA# 
@6	piÝ}̠cЦՉ@`LPBKT+)+bȋ1&5+>##E%	A!Q,ʈ=GꙈvY$hU4;
jh>tU+ "LȐi.r)	 ),PHBt) 9^C;H;<`Rb+1 Db  )  )	jh5!Ӕ )@&0>TM$Z'+MrUԈd^<Rpd]J>
qsTl""S"B'Jq5.mInD$?z@iȃiM[oB'~.c?\ 7hc5~4pk
*d?A$;u3S}a v Td5$=W|?!4(z2z*SdvA`(,$ Q"k["SBb	?(R\ fb*DcE	)XeD*"EaFKJ03Y>A-g}]6XHD#	1}xߓ8ܸ]Tl9*M.Mf1,}\#ҏ(odhZ}{)R$O?D)]P
